/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.common.items.armor;

import com.obscuria.aquamirae.Aquamirae;
import com.obscuria.aquamirae.common.items.AquamiraeMaterials;
import com.obscuria.aquamirae.registry.AquamiraeEffects;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.obscureapi.api.utils.ItemUtils;
import com.obscuria.obscureapi.common.classes.ClassItem;
import com.obscuria.obscureapi.common.classes.ability.Ability;
import com.obscuria.obscureapi.common.classes.ability.RegisterAbility;
import com.obscuria.obscureapi.common.classes.ability.context.AbilityContext;
import com.obscuria.obscureapi.common.classes.ability.context.SimpleAbilityContext;
import com.obscuria.obscureapi.common.classes.bonus.Bonus;
import com.obscuria.obscureapi.common.classes.bonus.RegisterBonus;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

@ClassItem(value="aquamirae:sea_wolf", type="armor")
public abstract class AbyssalArmorItem
extends class_1738 {
    public static final Ability HALFSET = Ability.create((String)"aquamirae", (String)"abyssal_armor_half").action(AbyssalArmorItem::applyStrongArmor).style(Ability.Style.ATTRIBUTE).build(AbyssalArmorItem.class);
    public static final Ability FULLSET_HEAUME = Ability.create((String)"aquamirae", (String)"abyssal_armor_full_1").cost(Ability.CostType.COOLDOWN, 60).build(AbyssalArmorItem.class);
    public static final Ability FULLSET_TIARA = Ability.create((String)"aquamirae", (String)"abyssal_armor_full_2").action(AbyssalArmorItem::applyTiaraEffect).build(AbyssalArmorItem.class);
    public static final Bonus BONUS_AMOUNT = Bonus.create().target(Aquamirae.SEA_WOLF, "weapon").type(Bonus.Type.POWER, Bonus.Operation.AMOUNT).value(3).build();
    public static final Bonus BONUS_PERCENT = Bonus.create().target(Aquamirae.SEA_WOLF, "weapon").type(Bonus.Type.POWER, Bonus.Operation.PERCENT).value(25).build();

    public AbyssalArmorItem(class_1741 material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            HALFSET.use((AbilityContext)new SimpleAbilityContext(living, stack));
            FULLSET_TIARA.use((AbilityContext)new SimpleAbilityContext(living, stack));
        }
    }

    public static boolean applyStrongArmor(AbilityContext context, List<Integer> vars) {
        if (ItemUtils.countArmorPieces((class_1309)context.getUser(), (Class[])new Class[]{AbyssalArmorItem.class}) >= 2) {
            class_1293 effect = context.getUser().method_6112((class_1291)AquamiraeEffects.STRONG_ARMOR);
            if (effect != null) {
                effect.method_5590(new class_1293((class_1291)AquamiraeEffects.STRONG_ARMOR, 4, 0, false, false));
            } else {
                context.getUser().method_6092(new class_1293((class_1291)AquamiraeEffects.STRONG_ARMOR, 4, 0, false, false));
            }
            return true;
        }
        return false;
    }

    public static boolean tryAvoidDeath(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_7357().method_7904((class_1792)AquamiraeItems.ABYSSAL_HEAUME)) {
                return false;
            }
            int cooldown = 20 * FULLSET_HEAUME.getCost(entity);
            player.method_7357().method_7906((class_1792)AquamiraeItems.ABYSSAL_HEAUME, cooldown);
            entity.method_6092(new class_1293((class_1291)AquamiraeEffects.CRYSTALLIZATION, cooldown, 0, true, true));
            entity.method_6033(entity.method_6063());
            class_1799 head = entity.method_6118(class_1304.field_6169);
            class_1799 chest = entity.method_6118(class_1304.field_6174);
            class_1799 legs = entity.method_6118(class_1304.field_6172);
            class_1799 feet = entity.method_6118(class_1304.field_6166);
            head.method_7956(50, entity, e -> {});
            chest.method_7956(50, entity, e -> {});
            legs.method_7956(50, entity, e -> {});
            feet.method_7956(50, entity, e -> {});
            entity.method_37908().method_8396(null, entity.method_24515().method_10084(), class_3417.field_14931, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean applyTiaraEffect(AbilityContext context, List<Integer> vars) {
        if (context.getUser().method_6118(class_1304.field_6169).method_7909() instanceof Tiara && ItemUtils.countArmorPieces((class_1309)context.getUser(), (Class[])new Class[]{AbyssalArmorItem.class}) == 4) {
            class_243 center = context.getUser().method_19538().method_1031(0.0, 1.0, 0.0);
            List list = context.getUser().method_37908().method_8390(class_1588.class, new class_238(center, center).method_1014(4.0), e -> true);
            for (class_1588 monster : list) {
                monster.method_6092(new class_1293((class_1291)AquamiraeEffects.ABYSS_BLINDNESS, 10, 0, false, false));
            }
            double radius = 4.0;
            context.getUser().method_37908().method_8406((class_2394)class_2398.field_11216, center.method_10216() + Math.cos((double)context.getUser().field_6012 * 0.05) * 4.0, center.method_10214() - 0.5, center.method_10215() + Math.sin((double)context.getUser().field_6012 * 0.05) * 4.0, 0.0, 0.0, 0.0);
            context.getUser().method_37908().method_8406((class_2394)class_2398.field_11216, center.method_10216() + Math.cos((double)context.getUser().field_6012 * 0.05 + 3.12) * 4.0, center.method_10214() - 0.5, center.method_10215() + Math.sin((double)context.getUser().field_6012 * 0.05 + 3.12) * 4.0, 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    public static class Heaume
    extends AbyssalArmorItem {
        @RegisterAbility
        public static final Ability HALFSET = HALFSET;
        @RegisterAbility
        public static final Ability FULLSET_HEAUME = FULLSET_HEAUME;
        @RegisterBonus
        public static final Bonus BONUS = BONUS_AMOUNT;

        public Heaume(class_1792.class_1793 settings) {
            super(AquamiraeMaterials.ABYSSAL_ARMOR, class_1738.class_8051.field_41934, settings);
        }
    }

    public static class Tiara
    extends AbyssalArmorItem {
        @RegisterAbility
        public static final Ability HALFSET = HALFSET;
        @RegisterAbility
        public static final Ability FULLSET_TIARA = FULLSET_TIARA;
        @RegisterBonus
        public static final Bonus BONUS = BONUS_AMOUNT;

        public Tiara(class_1792.class_1793 settings) {
            super(AquamiraeMaterials.ABYSSAL_ARMOR_EXTRA, class_1738.class_8051.field_41934, settings);
        }
    }

    public static class Boots
    extends AbyssalArmorItem {
        @RegisterAbility
        public static final Ability HALFSET = HALFSET;
        @RegisterBonus
        public static final Bonus BONUS = BONUS_AMOUNT;

        public Boots(class_1792.class_1793 settings) {
            super(AquamiraeMaterials.ABYSSAL_ARMOR, class_1738.class_8051.field_41937, settings);
        }
    }

    public static class Leggings
    extends AbyssalArmorItem {
        @RegisterAbility
        public static final Ability HALFSET = HALFSET;
        @RegisterBonus
        public static final Bonus BONUS = BONUS_PERCENT;

        public Leggings(class_1792.class_1793 settings) {
            super(AquamiraeMaterials.ABYSSAL_ARMOR, class_1738.class_8051.field_41936, settings);
        }
    }

    public static class Brigantine
    extends AbyssalArmorItem {
        @RegisterAbility
        public static final Ability HALFSET = HALFSET;
        @RegisterBonus
        public static final Bonus BONUS = BONUS_PERCENT;

        public Brigantine(class_1792.class_1793 settings) {
            super(AquamiraeMaterials.ABYSSAL_ARMOR, class_1738.class_8051.field_41935, settings);
        }
    }
}

